
while (dev.cur() > 1) dev.off()
cat("\014")
rm(list=ls())

library("readr")
library("readxl")
library("writexl")
library("tidyr")
library("dplyr")
library("ggplot2")
library("stringr")
library("scales")
library("sf")
library("spdep")
library("sfdep")
library("viridis")

options(digits = 4,
        scipen = 999,
        max.print=102)

crcmag  <- colorRampPalette(colors=c("white", "#FF2D4E"))(6)
scales::show_col(crcmag)
crcblue <- colorRampPalette(colors=c("white", "#2B2674"))(6)
scales::show_col(crcblue)
crcgris <- colorRampPalette(colors=c("white", "#706F6F"))(6)
scales::show_col(crcgris)


propietarios <- read_xlsx("propietarios_select.xlsx")

nprop <- as.numeric(dim(propietarios)[1])

propietarios <- rbind(propietarios, c(nprop + 1, 9999999999, "OTRO" , "OTRO"))

nprop <- as.numeric(dim(propietarios)[1])

propietarios$NIT <- as.numeric(propietarios$NIT)

base <- read_delim("base7_F3_R175_20243T.csv",
                    delim = ";",
                    escape_double = FALSE,
                    locale = locale(decimal_mark = ","),
                    show_col_types = FALSE)

base <- base %>%

  rename(

    ID_MUNICIPIO = CODIGO_DANE_MUNICIPIO,

    PROPIO       = SITIO_PROPIO_COUBICACION,

    ID_PROPIETARIO  = PROPIETARIO_SITIO_COUBICACION
  ) %>%

  mutate(ID_PROPIETARIO=ifelse(ID_PROPIETARIO==0, ID_EMPRESA, ID_PROPIETARIO))

unique(base$DESC_EMPRESA)

base %>%
  filter(DESC_EMPRESA == "NETWORKS INTERCONNECTED BY EXPERTS COMUNICACIONES S.A.S") %>%
  nrow()

base <- base %>%
        filter(DESC_EMPRESA != "NETWORKS INTERCONNECTED BY EXPERTS COMUNICACIONES S.A.S")

unique(base$ID_PROPIETARIO)

View(as.data.frame(table(base$ID_PROPIETARIO)) %>%
  arrange(desc(Freq)))

base_caribe <- base %>% filter(ID_PROPIETARIO==900485736)

rm(base_caribe)

radiantes <- left_join(base, propietarios, by = join_by(ID_PROPIETARIO == NIT)) %>%
          mutate(

            SITE_ID = paste0(LONGITUD, "_", LATITUD),

            PROPIETARIO = ifelse(is.na(PROPIETARIO), "OTRO", PROPIETARIO)
          )

nrow(radiantes)

table(radiantes$DESC_EMPRESA)

prop.table(table(radiantes$DESC_EMPRESA))

unique(radiantes$PROPIETARIO)

as.data.frame(table(radiantes$PROPIETARIO)) %>%
  arrange(desc(Freq))

sitios_operador <- radiantes %>%
  filter(ANNO==2024, TRIMESTRE==3) %>%
  group_by(DESC_EMPRESA) %>%
  summarise(TOTAL=n_distinct(SITE_ID))%>%
  arrange(desc(TOTAL))
sitios_operador

sum(sitios_operador[,2])

length(unique(radiantes$SITE_ID))

sum(sitios_operador[,2])/length(unique(radiantes$SITE_ID))

sitios_propietario <- radiantes %>%
  filter(ANNO==2024, TRIMESTRE==3) %>%
  filter(TIPO %in% c("OPERADOR", "TORRERO")) %>%
  group_by(PROPIETARIO) %>%
  summarise(TOTAL=n_distinct(SITE_ID)) %>%
  arrange(desc(TOTAL))
sitios_propietario <- sitios_propietario %>%
  mutate(PORCENTAJE=TOTAL/sum(sitios_propietario[,2]))
View(sitios_propietario)
sum(sitios_propietario[,2])

municipios <- st_read("SHP_MGN_DANE_MUNICIPAL/MGN_ANM_MPIOS.shp")
municipios$MPIO_CDPMP <- as.numeric(municipios$MPIO_CDPMP)

calc_ihh <- function(vectorcito){
  vectorcito <-
  share <- vectorcito/sum(vectorcito)
  ihh <- as.numeric(share%*%share)
  return(ihh)
}

ihhbdpre <- radiantes %>%
  group_by(ID_MUNICIPIO, ID_EMPRESA) %>%
  summarise(SITIOS=n()) %>%
  group_by(ID_MUNICIPIO) %>%
  summarise(IHH_PREVIO=calc_ihh(SITIOS))

ihhbdpre <- ihhbdpre %>%
  mutate(CONCENTRADO_PREVIO=if_else(IHH_PREVIO>=0.3,1,0)) %>%
  mutate(MONOPOLIO_PRE=if_else(IHH_PREVIO==1,1,0))

PORCENTAJE_CONCENTRADOS <- sum(ihhbdpre$CONCENTRADO_PREVIO)/nrow(ihhbdpre)
PORCENTAJE_CONCENTRADOS

sum(ihhbdpre$MONOPOLIO_PRE)
PORCENTAJE_MONOPOLIOS <- sum(ihhbdpre$MONOPOLIO_PRE)/nrow(ihhbdpre)
PORCENTAJE_MONOPOLIOS

municipios_datos <- left_join(municipios, ihhbdpre, by = c("MPIO_CDPMP" = "ID_MUNICIPIO"))
head(municipios_datos)

mapaihhpre <- ggplot() +
  geom_sf(data = municipios_datos, aes(fill = IHH_PREVIO), color = NA) +
  scale_fill_gradient(
    low = crcmag[1],
    high = crcmag[6],
    na.value = crcgris[6],
    name = "IHH PREVIO"
  ) +
  theme_minimal() +
  theme(
    legend.text = element_text(size = 14),
    legend.title = element_text(size = 16, face = "bold")
  )

mapaihhpre

mapaihhpre2 <- ggplot() +
  geom_sf(data = municipios_datos, aes(fill = IHH_PREVIO), color = NA) +
  scale_fill_gradient(low = crcmag[1], high = crcmag[6], na.value = crcgris[6]) +
  theme_minimal()+
  coord_sf(xlim = c(-81.8, -81.3), ylim = c(12.45, 12.65), expand = TRUE) +
  theme(legend.position = "right")
mapaihhpre2

radiantespost <- radiantes %>%
  mutate(
    ID_EMPRESA = case_when(
      ID_EMPRESA %in% c(830122566, 830114921) ~ 123456789,
      TRUE ~ ID_EMPRESA
    ),
    DESC_EMPRESA = case_when(
      DESC_EMPRESA %in% c("COLOMBIA MOVIL  S.A ESP", "COLOMBIA TELECOMUNICACIONES S.A. E.S.P.") ~ "INTEGRADA",
      TRUE ~ DESC_EMPRESA
    ),
    PROPIETARIO = case_when(
      PROPIETARIO %in% c("COLOMBIA MOVIL  S.A ESP", "COLOMBIA TELECOMUNICACIONES S.A. E.S.P.") ~ "INTEGRADA",
      TRUE ~ PROPIETARIO
    )
  )

ihhbdpost <- radiantespost %>%
  group_by(ID_MUNICIPIO, ID_EMPRESA) %>%
  summarise(SITIOS=n()) %>%
  group_by(ID_MUNICIPIO) %>%
  summarise(IHH_POSTERIOR=calc_ihh(SITIOS))

ihhbdpost <- ihhbdpost %>%
  mutate(CONCENTRADO_POSTERIOR=if_else(IHH_POSTERIOR>=0.3,1,0)) %>%
  mutate(MONOPOLIO_POST=if_else(IHH_POSTERIOR==1,1,0))

municipios_datos <- left_join(municipios, ihhbdpost, by = c("MPIO_CDPMP" = "ID_MUNICIPIO"))
head(municipios_datos)

mapaihhpost <- ggplot() +
  geom_sf(data = municipios_datos, aes(fill = IHH_POSTERIOR), color = NA) +
  scale_fill_gradient(low = crcmag[1],
                        high = crcmag[6],
                        na.value = crcgris[6],
                        name = "IHH POSTERIOR")+
  theme(legend.text = element_text(size = 14),
        Legend.title = element_text(size = 16, face = "bold"))+
  theme_minimal()

  mapaihhpost

mapaihhpost2 <- ggplot() +
  geom_sf(data = municipios_datos, aes(fill = IHH_POSTERIOR), color = NA) +
  scale_fill_gradient(low = crcmag[1], high = crcmag[6], na.value = crcgris[6]) +
  theme_minimal()+
  coord_sf(xlim = c(-81.8, -81.3), ylim = c(12.45, 12.65), expand = TRUE) +
  theme(legend.position = "right")
mapaihhpost2

ihh <- ihhbdpre %>%
  left_join(ihhbdpost, by = "ID_MUNICIPIO") %>%
  mutate(DIFF_IHH = IHH_POSTERIOR - IHH_PREVIO)

filter(ihh, DIFF_IHH >= 0.1) %>%
  nrow()
filter(ihh, DIFF_IHH == 0) %>%
  nrow()

SF <- municipios_datos

SF$IHH_PREVIO[is.na(SF$IHH_PREVIO)] <- mean(SF$IHH_PREVIO, na.rm = TRUE)

SF_corregido <- st_make_valid(SF)
vec <- poly2nb(SF_corregido, queen = TRUE)
vec_null <- which(card(vec) == 0)

SF_subconjunto <- SF_corregido[-vec_null, ]
SF_vec <- poly2nb(SF_subconjunto, queen = TRUE)

SF_peso <- nb2listw(SF_vec, style="B")
SF_lag1 <- lag.listw(SF_peso, SF_subconjunto$IHH_PREVIO)

globalG.test(SF_subconjunto$IHH_PREVIO, SF_peso)

SF_vecs_PREVIO <- SF_subconjunto %>% mutate(
    vec = st_contiguity(geometry),
    peso = st_weights(vec),
    tes_lag = st_lag(IHH_PREVIO, vec, peso)
)

SF_pc_PREVIO <- SF_vecs_PREVIO %>% mutate(Gi = local_g_perm(IHH_PREVIO, vec, peso, nsim = 999)) %>% unnest(Gi)

SF_pc_PREVIO %>% select(gi, p_folded_sim) %>% mutate(Clasificación = case_when(
    gi > 0 & p_folded_sim <= 0.01 ~ "Muy caliente",
    gi > 0 & p_folded_sim <= 0.05 ~ "Caliente",
    gi > 0 & p_folded_sim <= 0.1 ~ "Un poco caliente",
    gi < 0 & p_folded_sim <= 0.01 ~ "Muy frío",
    gi < 0 & p_folded_sim <= 0.05 ~ "Frío",
    gi < 0 & p_folded_sim <= 0.1 ~ "Un poco frío",
    TRUE ~ "Insignificante"),
    Clasificación = factor(Clasificación, levels = c(
        "Muy caliente", "Caliente", "Un poco caliente", "Insignificante",
        "Un poco frío", "Frío", "Muy frío"))) %>%
    ggplot(aes(fill = Clasificación)) +
    geom_sf(color = NA, lwd = 0.05) +
    scale_fill_brewer(type = "div", palette = 5) +
    theme_void() +
    labs(fill = "Clasificación de puntos calientes", title = "Puntos de concentración en Colombia antes de la integración")

MUNICIPIOS <- select(SF_pc_PREVIO, MPIO_CDPMP, DPTO_CCDGO, MPIO_CCDGO, gi, p_value, p_folded_sim)
MUNICIPIOS <- st_drop_geometry(MUNICIPIOS)
colnames(MUNICIPIOS)[1] <- "ID_MUNICIPIO"
colnames(MUNICIPIOS)[4] <- "gi_PREVIO"
colnames(MUNICIPIOS)[5] <- "p_value_PREVIO"
colnames(MUNICIPIOS)[6] <- "p_folded_sim_PREVIO"

MUNICIPIOS <- MUNICIPIOS %>% mutate(CLASS_PREVIO = case_when(
    gi_PREVIO > 0 & p_folded_sim_PREVIO <= 0.01 ~ "Muy caliente",
    gi_PREVIO > 0 & p_folded_sim_PREVIO <= 0.05 ~ "Caliente",
    gi_PREVIO > 0 & p_folded_sim_PREVIO <= 0.1 ~ "Un poco caliente",
    gi_PREVIO < 0 & p_folded_sim_PREVIO <= 0.01 ~ "Muy frío",
    gi_PREVIO < 0 & p_folded_sim_PREVIO <= 0.05 ~ "Frío",
    gi_PREVIO < 0 & p_folded_sim_PREVIO <= 0.1 ~ "Un poco frío",
    TRUE ~ "Insignificante"))

ihhbdpre <- merge(ihhbdpre, select(MUNICIPIOS, ID_MUNICIPIO, DPTO_CCDGO, MPIO_CCDGO, CLASS_PREVIO) , by = "ID_MUNICIPIO", sort = FALSE, all.x = TRUE)

write_xlsx(ihhbdpre, "ihhbdpre.xlsx")

coubicados <- radiantes %>%
              filter(PROPIO==2)

prop.table(table(coubicados$DESC_EMPRESA))

coubicados <-  coubicados

claro<- radiantes %>%
        filter(DESC_EMPRESA=="COMUNICACION CELULAR S A COMCEL S A")
prop.table(table(claro$PROPIO))

tigo<- radiantes %>%
  filter(DESC_EMPRESA=="COLOMBIA MOVIL  S.A ESP")
prop.table(table(tigo$PROPIO))

movistar<- radiantes %>%
  filter(DESC_EMPRESA=="COLOMBIA TELECOMUNICACIONES S.A. E.S.P.")
prop.table(table(movistar$PROPIO))

radiantesmax <- radiantes %>%
                group_by(ID_MUNICIPIO, DESC_EMPRESA) %>%
                mutate(RADIANTES=n()) %>%
                group_by(ID_MUNICIPIO) %>%
                slice_max(order_by = RADIANTES, n = 1, with_ties = FALSE) %>%
                select(ID_MUNICIPIO, DESC_EMPRESA, RADIANTES)
table(radiantesmax$DESC_EMPRESA)
prop.table(table(radiantesmax$DESC_EMPRESA))

municipios_datos <- left_join(municipios, radiantesmax, by = c("MPIO_CDPMP" = "ID_MUNICIPIO"))
head(municipios_datos)

mapamaxpre <- ggplot() +
  geom_sf(data = municipios_datos, aes(fill = DESC_EMPRESA), color = NA) +
  scale_fill_manual(values = c("COLOMBIA MOVIL  S.A ESP" = "blue",
                               "COLOMBIA TELECOMUNICACIONES S.A. E.S.P." = "green",
                               "COMUNICACION CELULAR S A COMCEL S A" = "red",
                               "PARTNERS TELECOM COLOMBIA SAS" = "purple")) +

  theme_minimal()
mapamaxpre

radiantesmaxpost <- radiantespost %>%
  group_by(ID_MUNICIPIO, DESC_EMPRESA) %>%
  mutate(RADIANTES=n()) %>%
  group_by(ID_MUNICIPIO) %>%
  slice_max(order_by = RADIANTES, n = 1, with_ties = FALSE) %>%
  select(ID_MUNICIPIO, DESC_EMPRESA, RADIANTES)
table(radiantesmaxpost$DESC_EMPRESA)
prop.table(table(radiantesmaxpost$DESC_EMPRESA))

municipios_datos <- left_join(municipios, radiantesmaxpost, by = c("MPIO_CDPMP" = "ID_MUNICIPIO"))
head(municipios_datos)

mapamaxpost <- ggplot() +
  geom_sf(data = municipios_datos, aes(fill = DESC_EMPRESA), color = NA) +
  scale_fill_manual(values = c("INTEGRADA" = "darkturquoise",
                               "COMUNICACION CELULAR S A COMCEL S A" = "red",
                               "PARTNERS TELECOM COLOMBIA SAS" = "purple")) +

  theme_minimal()
mapamaxpost
74

